@echo off
chcp 65001

echo 开始进行ADB刷机...

:: 设置APK文件路径(请根据实际路径修改)
set APK1="after_school.apk"
set APK2="device_find.apk"
set APK3="launcher.apk"
set FILE="apps.json"
set SYSTEM_PATH="/system/app/"
set ETC_PATH="/etc/link.qingzhou.launcher/files/"

:: 检查ADB是否可用
adb version >nul 2>&1
if %errorlevel% neq 0 (
    echo Error: ADB不可用，请确定是否设置了环境变量
    pause
    exit /b
)

:: 检查设备是否连接
adb devices | findstr /r /c:"device$" >nul
if %errorlevel% neq 0 (
    echo Error: 没有设备已连接.
    pause
    exit /b
)

:: 获取root权限
echo 获取root权限...
adb root
timeout /t 2 >nul

:: 重新挂载/system为读写权限
echo "挂载/system as read-write..."
adb remount
if %errorlevel% neq 0 (
    echo Error: 无法挂载/system.系统可能没有获取到root.
    pause
    exit /b
)

:: 推送第一个APK到/system/app
echo 推送放学系统主程序...
adb push %APK1% %SYSTEM_PATH%after_school/%APK1%
adb push armeabi %SYSTEM_PATH%after_school/lib/arm/
adb push armeabi-v7a %SYSTEM_PATH%after_school/lib/armeabi-v7a/
if %errorlevel% equ 0 (
    echo 成功推送到%SYSTEM_PATH%after_school
) else (
    echo 推送失败
)

:: 推送第二个APK到/system/app
echo 推送设备发现服务...
adb push %APK2% %SYSTEM_PATH%device_find_service/%APK2%

if %errorlevel% equ 0 (
    echo 成功推送到%SYSTEM_PATH%device_find_service
) else (
    echo 推送失败
)

:: 推送第三个APK到/system/app
echo 推送Launcher...
adb push %APK3% %SYSTEM_PATH%/launcher/%APK3%

if %errorlevel% equ 0 (
    echo 成功推送到%SYSTEM_PATH%launcher
) else (
    echo 推送失败
)

:: 推送额外文件到/system/app
echo 推送Launcher配置文件...
adb push %FILE% %ETC_PATH%apps.json
if %errorlevel% equ 0 (
    echo 成功推送到%ETC_PATH%apps.json
) else (
    echo 推送失败
)

echo 禁用系统桌面com.android.launcher3...
adb shell pm disable com.android.launcher3

:: 设置正确权限(可选，根据需要取消注释)
:: echo Setting permissions...
:: adb shell chmod 644 %SYSTEM_PATH%*.apk

:: 重启设备(可选，根据需要取消注释)
echo 准备重启设备...
adb reboot

echo 设置完成！！!
pause